//inspiration:
//http://news.povray.org/povray.binaries.images/thread/%3Cweb.456c9d7cb7f06341bc81efaa0@news.povray.org%3E/?ttop=237621&toff=50

#declare sun_height = simple_radius-2;
#declare wallPaperSky = true;
#declare traceSkyPatch = false;

#if (viewType != overView)
	#declare SkySphere =  sphere {
		0, simple_radius
		
		hollow
		texture { Land_Texture
			scale 4
		}
	
	}
	
	#declare grassTexture = texture {
		pigment {
//			color rgb <.5, 1, .5>
			color rgb <.4, 1, .4>
		}
		finish {
//			ambient .5
			ambient .4
		}
	}
	
	#declare vineTexture = texture {
		pigment {
			color rgb <1, 1, .2>
		}
		finish {
			ambient .8
		}
	}
	
	#if (renderSky | renderAll)
		#include "mgrass.inc"
		
		// --------------------------------------
		// Patch parameters
		// --------------------------------------
		// Final number of triangles = nBlade x nBlade x segBlade x 2 (or 4 if dofold = true)
		// --------------------------------------
		#declare lPatch=1;				// size of patch
		#declare nBlade=5;				// number of blades per line (there will be nBlade x nBlade blades); at least 2
		#declare ryBlade = 0;				// initial y rotation of blade
		#declare segBlade= 15;			// number of blade segments
		#declare lBlade = 2;				// length of blade
		#declare wBlade = .03;				// width of blade at start
		#declare wBladeEnd = 0.003;		// width of blade at the end
		#declare doSmooth=true;		// true makes smooth triangles
		#declare startBend = <0,1,0.3>;	// bending of blade at start (<0,1,0>=no bending)
		#declare vBend = <0,-0.5,0>;		// force bending the blade (<0,1,1> = 45)
		#declare pwBend = 3;				// bending power (how slowly the curve bends)
		#declare rd = 459;					// seed
		#declare stdposBlade = 1;		// standard deviation of blade position 0..1
		#declare stdrotBlade = 360;		// standard deviation of rotation
		#declare stdBlade = 1.2;			// standard deviation of blade scale;
		#declare stdBend = 2;				// standard deviation of blade bending;
		#declare dofold = true;			// true creates a central fold in the blade (twice more triangles)
		#declare dofile = true;				// true creates a mesh file
		#declare fname = "skygrass.inc" 	// name of the mesh file to create
		
		//create the grass patch
		#if (dofile) // if the patch is already created, turn off the next line
			//MakeGrassPatch(lPatch, nBlade, ryBlade, segBlade, lBlade, wBlade, wBladeEnd, doSmooth, startBend, vBend, pwBend, rd, stdposBlade, stdrotBlade, stdBlade, stdBend, dofold, dofile, fname)
			#declare SkyGrassPatch=#include fname
		#else
			#declare SkyGrassPatch=object{MakeGrassPatch(lPatch, nBlade, ryBlade, segBlade, lBlade, wBlade, wBladeEnd, doSmooth, startBend, vBend, pwBend, rd, stdposBlade, stdrotBlade, stdBlade, stdBend, dofold, dofile, fname)}
		#end
	
	
	
		//create the vines patch
		#declare nBlade=3;
		#declare lBlade = 5;
		#declare wBlade = .1;
		#declare wBladeEnd = 0.006;
		#declare rd = 989;
		#declare fname = "skyvine.inc";
	
		#if (dofile) // if the patch is already created, turn off the next line
			//MakeGrassPatch(lPatch, nBlade, ryBlade, segBlade, lBlade, wBlade, wBladeEnd, doSmooth, startBend, vBend, pwBend, rd, stdposBlade, stdrotBlade, stdBlade, stdBend, dofold, dofile, fname)
			#declare SkyVinePatch=#include fname
		#else
			#declare SkyVinePatch=object{MakeGrassPatch(lPatch, nBlade, ryBlade, segBlade, lBlade, wBlade, wBladeEnd, doSmooth, startBend, vBend, pwBend, rd, stdposBlade, stdrotBlade, stdBlade, stdBend, dofold, dofile, fname)}
		#end
	
	
	
		#declare grassRand = seed(42);
	
		#if (wallPaperSky)
			#declare CosineAngle = (2*pow(simple_radius, 2)-pow(lPatch, 2))/(2*pow(simple_radius, 2));
			#declare Angle = degrees(acos(CosineAngle));
			#declare currentZAngle = 0;
			#declare SkyGrass = union {
				#while (currentZAngle < 180)
					#declare zRotate = 90-currentZAngle;
					#declare currentXAngle = 0;
					#while (currentXAngle < 180)
						object { SkyGrassPatch
							#declare xRotate = 270-currentXAngle;
							rotate <0, 360*rand(grassRand), 0>
							texture { grassTexture }
							#if (traceSkyPatch)
								#declare patchStart = vrotate(<0, -simple_radius, 0>, <xRotate, 0, zRotate>);
								#declare patchStart = <patchStart.x, 0, patchStart.z>;
								#declare patchLoc = trace(SkySphere, patchStart, <0, 1, 0>, nvector);
								translate patchLoc
							#else
								translate <0, -simple_radius, 0>
								rotate <xRotate, 0, zRotate>
							#end
						}
						#declare currentXAngle = currentXAngle+ Angle;
					#end
					#declare currentZAngle = currentZAngle + Angle;
				#end
			}
		
		#else
			//randomly put a whole bunch up
			#declare currentClump = 0;
			#declare clumps = 50000;
			#declare SkyGrass = union {
				#while (currentClump < clumps)
					object { SkyGrassPatch
						rotate <0, 360*rand(grassRand), 0>
						texture { grassTexture }
						translate <0, -simple_radius, 0>
						#declare xRotate = 90+180*rand(grassRand);
						#declare zRotate = 90-180*rand(grassRand);
						rotate <xRotate, 0, zRotate>
					}
					#declare currentClump = currentClump + 1;
				#end
			}
		#end
		
		
		//randomly put the vines around
		#declare currentVine = 0;
		#declare vines = 1000;
		#declare vine_area = simple_radius*.9;
		#declare SkyVines = union {
			#while (currentVine < vines)
				object { SkyVinePatch
					rotate <0, 360*rand(grassRand), 0>
					rotate <180, 0, 0>
					#declare xTranslate = 2*vine_area*rand(grassRand)-vine_area;
					#declare yRotate = 360*rand(grassRand);
					translate <xTranslate, 0, 0>
					rotate <0, yRotate, 0>
					texture { vineTexture }
					#declare vineStart = vrotate(<xTranslate, 0, 0>, <0, yRotate, 0>);
	
					#declare vineLoc = trace(SkySphere, vineStart, <0, 1, 0>, nvector);
					translate <0, vineLoc.y, 0>
				}
				#declare currentVine = currentVine + 1;
			#end
			no_shadow
		}
		
		
		#declare SkySphere = union {
			object { SkySphere scale 1.1 }
			object { SkyGrass }
			object { SkyVines }
		}
	#end
#end